//---------------------------------------------------------
#ifndef usb_R5_4H
#define usb_R5_4H
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#pragma option push -a1
   #include <setupapi>
#pragma option pop
#include <assert.h>
#include <ExtCtrls.hpp>
#include <Graphics.hpp>
#include <ComCtrls.hpp>

#define bufferLength 32
//---------------------------------------------------------
typedef USHORT USAGE, *PUSAGE;
typedef struct _HIDP_PREPARSED_DATA *PHIDP_PREPARSED_DATA;
//---------------------------------------------------------
typedef struct _HIDP_CAPS {
   USAGE Usage;
   USAGE UsagePage;
   USHORT InputReportByteLength;
   USHORT OutputReportByteLength;
   USHORT FeatureReportByteLength;
   USHORT Reserved[17];
   USHORT NumberLinkCollectionNodes;
   USHORT NumberInputButtonCaps;
   USHORT NumberInputValueCaps;
   USHORT NumberInputDataIndices;
   USHORT NumberOutputButtonCaps;
   USHORT NumberOutputValueCaps;
   USHORT NumberOutputDataIndices;
   USHORT NumberFeatureButtonCaps;
   USHORT NumberFeatureValueCaps;
   USHORT NumberFeatureDataIndices;
} HIDP_CAPS, *PHIDP_CAPS;
//---------------------------------------------------------
typedef struct _HIDD_ATTRIBUTES
  {
    ULONG Size;
    USHORT VendorID;
    USHORT ProductID;
    USHORT VersionNumber;
} HIDD_ATTRIBUTES, *PHIDD_ATTRIBUTES;
//---------------------------------------------------------
template <class T>
inline void releaseMemory(T &x)
{
  assert(x != NULL);
  delete x;
  x = NULL;
}
//---------------------------------------------------------
class TForm1 : public TForm
{
  __published:	// IDE-managed Components
     TButton *Button1;
     TTrackBar *TrackBar1;
     TProgressBar *ProgressBar1;
     TLabel *Label1;
     TLabel *Label2;
     TMemo *Memo1;
     void __fastcall Button1Click(TObject *Sender);
     void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
  private:	// User declarations
     HIDD_ATTRIBUTES hiddAttributes;
     HIDP_CAPS capabilities;
     PHIDP_PREPARSED_DATA preparsedData;
     GUID classGuid;
     HMODULE hHidLib;
     DWORD memberIndex;
     DWORD deviceInterfaceDetailDataSize;
     HDEVINFO deviceInfoSet;
     SP_DEVICE_INTERFACE_DATA deviceInterfaceData;
     PSP_DEVICE_INTERFACE_DETAIL_DATA deviceInterfaceDetailData;
     HANDLE  hidDeviceObject;
     BYTE inputReportBuffer[bufferLength]; //bufor danych wejsciowych
     DWORD numberOfBytesRead;
     TPoint points[5];
     void __fastcall displayError(const char* msg);
  public:		// User declarations
       void __fastcall showCapabilitiesDevice(TObject *Sender);
     __fastcall TForm1(TComponent* Owner);
};
//---------------------------------------------------------
extern PACKAGE TForm1 *Form1;
#endif
//---------------------------------------------------------
